<?php
/**
* bxSlider v4.2.12
* Copyright 2013-2015 Steven Wanderski
* Written while drinking Belgian ales and listening to jazz
* Licensed under MIT (http://opensource.org/licenses/MIT)
*/

c(';(function($){');
	c('var defaults={');
		#c('/*GENERAL*/');
		c('mode:"horizontal",');
		c('slideSelector:"",');
		c('infiniteLoop:true,');
		c('hideControlOnEnd:false,');
		c('speed:500,');
		c('easing:null,');
		c('slideMargin:0,');
		c('startSlide:0,');
		c('randomStart:false,');
		c('captions:false,');
		c('ticker:false,');
		c('tickerHover:false,');
		c('adaptiveHeight:false,');
		c('adaptiveHeightSpeed:500,');
		c('video:false,');
		c('useCSS:true,');
		c('preloadImages:"visible",');
		c('responsive:true,');
		c('slideZIndex:50,');
		c('wrapperClass:"bx-wrapper",');
		#c('/*TOUCH*/');
		c('touchEnabled:true,');
		c('swipeThreshold:50,');
		c('oneToOneTouch:true,');
		c('preventDefaultSwipeX:true,');
		c('preventDefaultSwipeY:false,');
		#c('/*ACCESSIBILITY*/');
		c('ariaLive:true,');
		c('ariaHidden:true,');
		#c('/*KEYBOARD*/');
		c('keyboardEnabled:false,');
		#c('/*PAGER*/');
		c('pager:true,');
		c('pagerType:"full",');
		c('pagerShortSeparator:" / ",');
		c('pagerSelector:null,');
		c('buildPager:null,');
		c('pagerCustom:null,');
		#c('/*CONTROLS*/');
		c('controls:true,');
		c('nextText:"Next",');
		c('prevText:"Prev",');
		c('nextSelector:null,');
		c('prevSelector:null,');
		c('autoControls:false,');
		c('startText:"Start",');
		c('stopText:"Stop",');
		c('autoControlsCombine:false,');
		c('autoControlsSelector:null,');
		#c('/*AUTO*/');
		c('auto:false,');
		c('pause:4000,');
		c('autoStart:true,');
		c('autoDirection:"next",');
		c('stopAutoOnClick:false,');
		c('autoHover:false,');
		c('autoDelay:0,');
		c('autoSlideForOnePage:false,');
		#c('/*CAROUSEL*/');
		c('minSlides:1,');
		c('maxSlides:1,');
		c('moveSlides:0,');
		c('slideWidth:0,');
		c('shrinkItems:false,');
		#c('/*CALLBACKS*/');
		c('onSliderLoad:function(){return true;},');
		c('onSlideBefore:function(){return true;},');
		c('onSlideAfter:function(){return true;},');
		c('onSlideNext:function(){return true;},');
		c('onSlidePrev:function(){return true;},');
		c('onSliderResize:function(){return true;}');
	c('};');

	c('$.fn.bxSlider=function(options){');
		c('if(this.length===0){');
			c('return this;');
		c('}');
		#c('/*support multiple elements*/');
		c('if(this.length > 1){');
			c('this.each(function(){');
				c('$(this).bxSlider(options);');
			c('});');
			c('return this;');
		c('}');
		#c('/*create a namespace to be used throughout the plugin*/');');
		c('var slider={},');
		#c('/*set a reference to our slider element*/');
		c('el=this,');
		#c('/*get the original window dimens (thanks a lot IE)*/');
		c('windowWidth=$(window).width(),');
		c('windowHeight=$(window).height();');
		#c('/*Return if slider is already initialized*/');
		c('if($(el).data("bxSlider")){return;}');
	/**
	* ===================================================================================
	*=PRIVATE FUNCTIONS
	* ===================================================================================
	*/

	/**
	* Initializes namespace settings to be used throughout plugin
	*/
	c('var init=function(){');
		#c('/*Return if slider is already initialized*/');');
		c('if($(el).data("bxSlider")){return;}');
		#c('/*merge user-supplied options with the defaults*/');
		c('slider.settings=$.extend({},defaults,options);');
		#c('/*parse slideWidth setting*/');
		c('slider.settings.slideWidth=parseInt(slider.settings.slideWidth);');
		#c('/*store the original children*/');
		c('slider.children=el.children(slider.settings.slideSelector);');
		#c('/*check if actual number of slides is less than minSlides / maxSlides*/');
		c('if(slider.children.length < slider.settings.minSlides){slider.settings.minSlides=slider.children.length;}');
		c('if(slider.children.length < slider.settings.maxSlides){slider.settings.maxSlides=slider.children.length;}');
		#c('/*if random start,set the startSlide setting to random number*/');
		c('if(slider.settings.randomStart){slider.settings.startSlide=Math.floor(Math.random() * slider.children.length);}');
		#c('/*store active slide information*/');
		c('slider.active={index:slider.settings.startSlide};');
		#c('/*store if the slider is in carousel mode (displaying / moving multiple slides)*/');
		c('slider.carousel=slider.settings.minSlides > 1 || slider.settings.maxSlides > 1?true:false;');
		#c('/*if carousel,force preloadImages="all"*/');
		c('if(slider.carousel){slider.settings.preloadImages="all";}');
		#c('/*calculate the min / max width thresholds based on min / max number of slides*/');
		#c('/*used to setup and update carousel slides dimensions*/');
		c('slider.minThreshold=(slider.settings.minSlides * slider.settings.slideWidth) + ((slider.settings.minSlides - 1) * slider.settings.slideMargin);');
		c('slider.maxThreshold=(slider.settings.maxSlides * slider.settings.slideWidth) + ((slider.settings.maxSlides - 1) * slider.settings.slideMargin);');
		#c('/*store the current state of the slider (if currently animating,working is true)*/');
		c('slider.working=false;');
		#c('/*initialize the controls object*/');
		c('slider.controls={};');
		#c('/*initialize an auto interval*/');
		c('slider.interval=null;');
		#c('/*determine which property to use for transitions*/');
		c('slider.animProp=slider.settings.mode==="vertical"?"top":"left";');
		#c('/*determine if hardware acceleration can be used*/');
		c('slider.usingCSS=slider.settings.useCSS && slider.settings.mode!=="fade" && (function(){');
			#c('/*create our test div element*/');
			c('var div=document.createElement("div"),');
			#c('/*css transition properties*/');
			c('props=["WebkitPerspective","MozPerspective","OPerspective","msPerspective"];');
			#c('/*test for each property*/');
			c('for(var i=0; i < props.length; i++){');
				c('if(div.style[props[i]]!==undefined){');
					c('slider.cssPrefix=props[i].replace("Perspective","").toLowerCase();');
					c('slider.animProp="-" + slider.cssPrefix + "-transform";');
					c('return true;');
				c('}');
			c('}');
			c('return false;');
		c('}());');
		#c('/*if vertical mode always make maxSlides and minSlides equal*/');
		c('if(slider.settings.mode==="vertical"){slider.settings.maxSlides=slider.settings.minSlides;}');
		#c('/*save original style data*/');
		c('el.data("origStyle",el.attr("style"));');
		c('el.children(slider.settings.slideSelector).each(function(){');
			c('$(this).data("origStyle",$(this).attr("style"));');
		c('});');
		#c('/*perform all DOM / CSS modifications*/');
		c('setup();');
	c('};');

	/**
	* Performs all DOM and CSS modifications
	*/
	c('var setup=function(){');
		#c('/*set the default preload selector (visible)*/');
		c('var preloadSelector=slider.children.eq(slider.settings.startSlide);');
		#c('/*wrap el in a wrapper*/');
		c('el.wrap("<div class=\""+ slider.settings.wrapperClass +"\"><div class=\"bx-viewport\"></div></div>");');
		#c('/*store a namespace reference to .bx-viewport*/');
		c('slider.viewport=el.parent();');
		#c('/*add aria-live if the setting is enabled and ticker mode is disabled*/');
		c('if(slider.settings.ariaLive && !slider.settings.ticker){');
			c('slider.viewport.attr("aria-live","polite");');
		c('}');
		#c('/*add a loading div to display while images are loading*/');
		c('slider.loader=$("<div class=\"bx-loading\"/>");');
		c('slider.viewport.prepend(slider.loader);');
		#c('/*set el to a massive width,to hold any needed slides*/');
		#c('/*also strip any margin and padding from el*/');
		c('el.css({');
			c('width:slider.settings.mode==="horizontal"?(slider.children.length * 1000 + 215) + "%":"auto",');
			c('position:"relative"');
		c('});');
		#c('/*if using CSS,add the easing property*/');
		c('if(slider.usingCSS && slider.settings.easing){');
			c('el.css("-" + slider.cssPrefix + "-transition-timing-function",slider.settings.easing);');
			#c('/*if not using CSS and no easing value was supplied,use the default JS animation easing (swing)*/');
		c('}else if(!slider.settings.easing){');
			c('slider.settings.easing="swing";');
		c('}');
		#c('/*make modifications to the viewport (.bx-viewport)*/');
		c('slider.viewport.css({');
			c('width:"100%",');
			c('overflow:"hidden",');
			c('position:"relative"');
		c('});');
		c('slider.viewport.parent().css({');
			c('maxWidth:getViewportMaxWidth()');
		c('});');
		#c('/*apply css to all slider children*/');
		c('slider.children.css({');
			c('float:slider.settings.mode==="horizontal"?"left":"none",');
			c('listStyle:"none",');
			c('position:"relative"');
		c('});');
		#c('/*apply the calculated width after the float is applied to prevent scrollbar interference*/');
		c('slider.children.css("width",getSlideWidth());');
		#c('/*if slideMargin is supplied,add the css*/');
		c('if(slider.settings.mode==="horizontal" && slider.settings.slideMargin > 0){slider.children.css("marginRight",slider.settings.slideMargin);}');
		c('if(slider.settings.mode==="vertical" && slider.settings.slideMargin > 0){slider.children.css("marginBottom",slider.settings.slideMargin);}');
		#c('/*if "fade" mode,add positioning and z-index CSS*/');
		c('if(slider.settings.mode==="fade"){');
			c('slider.children.css({');
				c('position:"absolute",');
				c('zIndex:0,');
				c('display:"none"');
			c('});');
			#c('/*prepare the z-index on the showing element*/');
			c('slider.children.eq(slider.settings.startSlide).css({zIndex:slider.settings.slideZIndex,display:"block"});');
		c('}');
		#c('/*create an element to contain all slider controls (pager,start / stop,etc)*/');
		c('slider.controls.el=$("<div class=\"bx-controls\" />");');
		#c('/*if captions are requested,add them*/');
		c('if(slider.settings.captions){appendCaptions();}');
		#c('/*check if startSlide is last slide*/');
		c('slider.active.last=slider.settings.startSlide===getPagerQty() - 1;');
		#c('/*if video is true,set up the fitVids plugin*/');
		c('if(slider.settings.video){el.fitVids();}');
		c('if(slider.settings.preloadImages==="all" || slider.settings.ticker){preloadSelector=slider.children;}');
		#c('/*only check for control addition if not in "ticker" mode*/');
		c('if(!slider.settings.ticker){');
			#c('/*if controls are requested,add them*/');
			c('if(slider.settings.controls){appendControls();}');
			#c('/*if auto is true,and auto controls are requested,add them*/');
			c('if(slider.settings.auto && slider.settings.autoControls){appendControlsAuto();}');
			#c('/*if pager is requested,add it*/');
			c('if(slider.settings.pager){appendPager();}');
			#c('/*if any control option is requested,add the controls wrapper*/');
			c('if(slider.settings.controls || slider.settings.autoControls || slider.settings.pager){slider.viewport.after(slider.controls.el);}');
			#c('/*if ticker mode,do not allow a pager*/');
		c('}else{');
			c('slider.settings.pager=false;');
		c('}');
		c('loadElements(preloadSelector,start);');
	c('};');
	c('var loadElements=function(selector,callback){');
		c('var total=selector.find("img:not([src=\"\"]),iframe").length,');
		c('count=0;');
		c('if(total===0){');
			c('callback();');
			c('return;');
		c('}');
		c('selector.find("img:not([src=\"\"]),iframe").each(function(){');
			c('$(this).one("load error",function(){');
				c('if(++count===total){callback();}');
			c('}).each(function(){');
				c('if(this.complete){$(this).trigger("load");}');
			c('});');
		c('});');
	c('};');

	/**
	* Start the slider
	*/
	c('var start=function(){');
		#c('/*if infinite loop,prepare additional slides*/');
		c('if(slider.settings.infiniteLoop && slider.settings.mode!=="fade" && !slider.settings.ticker){');
			c('var slice=slider.settings.mode==="vertical"?slider.settings.minSlides:slider.settings.maxSlides,');
			c('sliceAppend=slider.children.slice(0,slice).clone(true).addClass("bx-clone"),');
			c('slicePrepend=slider.children.slice(-slice).clone(true).addClass("bx-clone");');
			c('if(slider.settings.ariaHidden){');
				c('sliceAppend.attr("aria-hidden",true);');
				c('slicePrepend.attr("aria-hidden",true);');
			c('}');
			c('el.append(sliceAppend).prepend(slicePrepend);');
		c('}');
		#c('/*remove the loading DOM element*/');
		c('slider.loader.remove();');
		#c('/*set the left / top position of "el"*/');
		c('setSlidePosition();');
		#c('/*if "vertical" mode,always use adaptiveHeight to prevent odd behavior*/');
		c('if(slider.settings.mode==="vertical"){slider.settings.adaptiveHeight=true;}');
		#c('/*set the viewport height*/');
		c('slider.viewport.height(getViewportHeight());');
		#c('/*make sure everything is positioned just right (same as a window resize)*/');
		c('el.redrawSlider();');
		#c('/*onSliderLoad callback*/');
		c('slider.settings.onSliderLoad.call(el,slider.active.index);');
		#c('/*slider has been fully initialized*/');
		c('slider.initialized=true;');
		#c('/*bind the resize call to the window*/');
		c('if(slider.settings.responsive){$(window).bind("resize",resizeWindow);}');
		#c('/*if auto is true and has more than 1 page,start the show*/');
		c('if(slider.settings.auto && slider.settings.autoStart && (getPagerQty() > 1 || slider.settings.autoSlideForOnePage)){initAuto();}');
		#c('/*if ticker is true,start the ticker*/');
		c('if(slider.settings.ticker){initTicker();}');
		#c('/*if pager is requested,make the appropriate pager link active*/');
		c('if(slider.settings.pager){updatePagerActive(slider.settings.startSlide);}');
		#c('/*check for any updates to the controls (like hideControlOnEnd updates)*/');
		c('if(slider.settings.controls){updateDirectionControls();}');
		#c('/*if touchEnabled is true,setup the touch events*/');
		c('if(slider.settings.touchEnabled && !slider.settings.ticker){initTouch();}');
		#c('/*if keyboardEnabled is true,setup the keyboard events*/');
		c('if(slider.settings.keyboardEnabled && !slider.settings.ticker){');
			c('$(document).keydown(keyPress);');
		c('}');
	c('};');

	/**
	* Returns the calculated height of the viewport,used to determine either adaptiveHeight or the maxHeight value
	*/
	c('var getViewportHeight=function(){');
		c('var height=0;');
		#c('/*first determine which children (slides) should be used in our height calculation*/');
		c('var children=$();');
		#c('/*if mode is not "vertical" and adaptiveHeight is false,include all children*/');
		c('if(slider.settings.mode!=="vertical" && !slider.settings.adaptiveHeight){');
			c('children=slider.children;	');
		c('}else{');
			#c('/*if not carousel,return the single active child*/');
			c('if(!slider.carousel){');
				c('children=slider.children.eq(slider.active.index);');
				#c('/*if carousel,return a slice of children*/');
			c('}else{');
				#c('/*get the individual slide index*/');
				c('var currentIndex=slider.settings.moveSlides===1?slider.active.index:slider.active.index * getMoveBy();');
				#c('/*add the current slide to the children*/');
				c('children=slider.children.eq(currentIndex);');
				#c('/*cycle through the remaining "showing" slides*/');
				c('for (i=1; i <= slider.settings.maxSlides - 1; i++){');
					#c('/*if looped back to the start*/');
					c('if(currentIndex + i >= slider.children.length){');
						c('children=children.add(slider.children.eq(i - 1));');
					c('}else{');
						c('children=children.add(slider.children.eq(currentIndex + i));');
					c('}');
				c('}');
			c('}');
		c('}');
		#c('/*if "vertical" mode,calculate the sum of the heights of the children*/');
		c('if(slider.settings.mode==="vertical"){');
			c('children.each(function(index){');
				c('height += $(this).outerHeight();');
			c('});');
			#c('/*add user-supplied margins*/');
			c('if(slider.settings.slideMargin > 0){');
				c('height += slider.settings.slideMargin * (slider.settings.minSlides - 1);');
			c('}');
			#c('/*if not "vertical" mode,calculate the max height of the children*/');
		c('}else{');
			c('height=Math.max.apply(Math,children.map(function(){');
				c('return $(this).outerHeight(false);');
			c('}).get());');
		c('}');
		c('if(slider.viewport.css("box-sizing")==="border-box"){');
			c('height += parseFloat(slider.viewport.css("padding-top")) + parseFloat(slider.viewport.css("padding-bottom")) +');
			c('parseFloat(slider.viewport.css("border-top-width")) + parseFloat(slider.viewport.css("border-bottom-width"));');
		c('}else if(slider.viewport.css("box-sizing")==="padding-box"){');
			c('height += parseFloat(slider.viewport.css("padding-top")) + parseFloat(slider.viewport.css("padding-bottom"));');
		c('}');
		c('return height;');
	c('};');

	/**
	* Returns the calculated width to be used for the outer wrapper / viewport
	*/
	c('var getViewportMaxWidth=function(){');
		c('var width="100%";');
		c('if(slider.settings.slideWidth > 0){');
			c('if(slider.settings.mode==="horizontal"){');
				c('width=(slider.settings.maxSlides * slider.settings.slideWidth) + ((slider.settings.maxSlides - 1) * slider.settings.slideMargin);');
			c('}else{');
				c('width=slider.settings.slideWidth;');
			c('}');
		c('}');
		c('return width;');
	c('};');

	/**
	* Returns the calculated width to be applied to each slide
	*/
	c('var getSlideWidth=function(){');
		#c('/*start with any user-supplied slide width*/');
		c('var newElWidth=slider.settings.slideWidth,');
		#c('/*get the current viewport width*/');
		c('wrapWidth=slider.viewport.width();');
		#c('/*if slide width was not supplied,or is larger than the viewport use the viewport width*/');
		c('if(slider.settings.slideWidth===0 || (slider.settings.slideWidth > wrapWidth && !slider.carousel) || slider.settings.mode==="vertical"){');
			c('newElWidth=wrapWidth;');
			#c('/*if carousel,use the thresholds to determine the width*/');
		c('}else if(slider.settings.maxSlides > 1 && slider.settings.mode==="horizontal"){');
			c('if(wrapWidth > slider.maxThreshold){');
				c('return newElWidth;');
			c('}else if(wrapWidth < slider.minThreshold){');
				c('newElWidth=(wrapWidth - (slider.settings.slideMargin * (slider.settings.minSlides - 1))) / slider.settings.minSlides;');
			c('}else if(slider.settings.shrinkItems){');
				c('newElWidth=Math.floor((wrapWidth + slider.settings.slideMargin) / (Math.ceil((wrapWidth + slider.settings.slideMargin) / (newElWidth + slider.settings.slideMargin))) - slider.settings.slideMargin);');
			c('}');
		c('}');
		c('return newElWidth;');
	c('};');

	/**
	* Returns the number of slides currently visible in the viewport (includes partially visible slides)
	*/
	c('var getNumberSlidesShowing=function(){');
		c('var slidesShowing=1,');
		c('childWidth=null;');
		c('if(slider.settings.mode==="horizontal" && slider.settings.slideWidth > 0){');
			#c('/*if viewport is smaller than minThreshold,return minSlides*/');
			c('if(slider.viewport.width() < slider.minThreshold){');
				c('slidesShowing=slider.settings.minSlides;');
				#c('/*if viewport is larger than maxThreshold,return maxSlides*/');
			c('}else if(slider.viewport.width() > slider.maxThreshold){');
				c('slidesShowing=slider.settings.maxSlides;');
				#c('/*if viewport is between min / max thresholds,divide viewport width by first child width*/');
			c('}else{');
				c('childWidth=slider.children.first().width() + slider.settings.slideMargin;');
				c('slidesShowing=Math.floor((slider.viewport.width() +');
				c('slider.settings.slideMargin) / childWidth);');
			c('}');
			#c('/*if "vertical" mode,slides showing will always be minSlides*/');
		c('}else if(slider.settings.mode==="vertical"){');
			c('slidesShowing=slider.settings.minSlides;');
		c('}');
		c('return slidesShowing;');
	c('};');

	/**
	* Returns the number of pages (one full viewport of slides is one "page")
	*/
	c('var getPagerQty=function(){');
		c('var pagerQty=0,');
		c('breakPoint=0,');
		c('counter=0;');
		#c('/*if moveSlides is specified by the user*/');
		c('if(slider.settings.moveSlides > 0){');
			c('if(slider.settings.infiniteLoop){');
				c('pagerQty=Math.ceil(slider.children.length / getMoveBy());');
			c('}else{');
				#c('/*when breakpoint goes above children length,counter is the number of pages*/');
				c('while (breakPoint < slider.children.length){');
					c('++pagerQty;');
					c('breakPoint=counter + getNumberSlidesShowing();');
					c('counter += slider.settings.moveSlides <= getNumberSlidesShowing()?slider.settings.moveSlides:getNumberSlidesShowing();');
				c('}');
			c('}');
			#c('/*if moveSlides is 0 (auto) divide children length by sides showing,then round up*/');
		c('}else{');
			c('pagerQty=Math.ceil(slider.children.length / getNumberSlidesShowing());');
		c('}');
		c('return pagerQty;');
	c('};');
	/**
	* Returns the number of individual slides by which to shift the slider
	*/
	c('var getMoveBy=function(){');
		#c('/*if moveSlides was set by the user and moveSlides is less than number of slides showing*/');
		c('if(slider.settings.moveSlides > 0 && slider.settings.moveSlides <= getNumberSlidesShowing()){');
			c('return slider.settings.moveSlides;');
		c('}');
		#c('/*if moveSlides is 0 (auto)*/');
		c('return getNumberSlidesShowing();');
	c('};');

	/**
	* Sets the slider's (el) left or top position
	*/
	c('var setSlidePosition=function(){');
		c('var position,lastChild,lastShowingIndex;');
		#c('/*if last slide,not infinite loop,and number of children is larger than specified maxSlides*/');
		c('if(slider.children.length > slider.settings.maxSlides && slider.active.last && !slider.settings.infiniteLoop){');
			c('if(slider.settings.mode==="horizontal"){');
				#c('/*get the last child\'s position*/');
				c('lastChild=slider.children.last();');
				c('position=lastChild.position();');
				#c('/*set the left position*/');
				c('setPositionProperty(-(position.left - (slider.viewport.width() - lastChild.outerWidth())),"reset",0);');
			c('}else if(slider.settings.mode==="vertical"){');
				#c('/*get the last showing index\'s position*/');
				c('lastShowingIndex=slider.children.length - slider.settings.minSlides;');
				c('position=slider.children.eq(lastShowingIndex).position();');
				#c('/*set the top position*/');
				c('setPositionProperty(-position.top,"reset",0);');
			c('}');
			#c('/*if not last slide*/');
		c('}else{');
			#c('/*get the position of the first showing slide*/');
			c('position=slider.children.eq(slider.active.index * getMoveBy()).position();');
			#c('/*check for last slide*/');
			c('if(slider.active.index===getPagerQty() - 1){slider.active.last=true;}');
			#c('/*set the respective position*/');
			c('if(position!==undefined){');
				c('if(slider.settings.mode==="horizontal"){setPositionProperty(-position.left,"reset",0);}');
				c('else if(slider.settings.mode==="vertical"){setPositionProperty(-position.top,"reset",0);}');
			c('}');
		c('}');
	c('};');

	/**
	* Sets the el's animating property position (which in turn will sometimes animate el).
	* If using CSS,sets the transform property. If not using CSS,sets the top / left property.
	*
	* @param value (int)
	*	- the animating property's value
	*
	* @param type (string) 'slide','reset','ticker'
	*	- the type of instance for which the function is being
	*
	* @param duration (int)
	*	- the amount of time (in ms) the transition should occupy
	*
	* @param params (array) optional
	*	- an optional parameter containing any variables that need to be passed in
	*/
	c('var setPositionProperty=function(value,type,duration,params){');
		c('var animateObj,propValue;');
			#c('/*use CSS transform*/');
			c('if(slider.usingCSS){');
				#c('/*determine the translate3d value*/');
				c('propValue=slider.settings.mode==="vertical"?"translate3d(0," + value + "px,0)":"translate3d(" + value + "px,0,0)";');
				#c('/*add the CSS transition-duration*/');
				c('el.css("-" + slider.cssPrefix + "-transition-duration",duration / 1000 + "s");');
				c('if(type==="slide"){');
					#c('/*set the property value*/');
					c('el.css(slider.animProp,propValue);');
					c('if(duration!==0){');
						#c('/*bind a callback method - executes when CSS transition completes*/');
						c('el.bind("transitionend webkitTransitionEnd oTransitionEnd MSTransitionEnd",function(e){');
							#c('/*make sure it\'s the correct one*/');
							c('if(!$(e.target).is(el)){return;}');
							#c('/*unbind the callback*/');
							c('el.unbind("transitionend webkitTransitionEnd oTransitionEnd MSTransitionEnd");');
							c('updateAfterSlideTransition();');
						c('});');
					c('}else{');
						#c('/*duration=0*/');
						c('updateAfterSlideTransition();');
					c('}');
				c('}else if(type==="reset"){');
					c('el.css(slider.animProp,propValue);');
				c('}else if(type==="ticker"){');
					#c('/*make the transition use "linear"*/');
					c('el.css("-" + slider.cssPrefix + "-transition-timing-function","linear");');
					c('el.css(slider.animProp,propValue);');
					c('if(duration!==0){');
						c('el.bind("transitionend webkitTransitionEnd oTransitionEnd MSTransitionEnd",function(e){');
							#c('/*make sure it\'s the correct one*/');
							c('if(!$(e.target).is(el)){return;}');
							#c('/*unbind the callback*/');
							c('el.unbind("transitionend webkitTransitionEnd oTransitionEnd MSTransitionEnd");');
							#c('/*reset the position*/');
							c('setPositionProperty(params.resetValue,"reset",0);');
							#c('/*start the loop again*/');
							c('tickerLoop();');
						c('});');
					c('}else{');
						#c('/*duration=0*/');
						c('setPositionProperty(params.resetValue,"reset",0);');
						c('tickerLoop();');
					c('}');
				c('}');
				#c('/*use JS animate*/');
			c('}else{');
				c('animateObj={};');
				c('animateObj[slider.animProp]=value;');
				c('if(type==="slide"){');
					c('el.animate(animateObj,duration,slider.settings.easing,function(){');
						c('updateAfterSlideTransition();');
					c('});');
				c('}else if(type==="reset"){');
					c('el.css(slider.animProp,value);');
				c('}else if(type==="ticker"){');
					c('el.animate(animateObj,duration,"linear",function(){');
						c('setPositionProperty(params.resetValue,"reset",0);');
						#c('/*run the recursive loop after animation*/');
						c('tickerLoop();');
					c('});');
				c('}');
			c('}');
		c('};');

		/**
		* Populates the pager with proper amount of pages
		*/
		c('var populatePager=function(){');
			c('var pagerHtml="",');
			c('linkContent="",');
			c('pagerQty=getPagerQty();');
			#c('/*loop through each pager item*/');
			c('for (var i=0; i < pagerQty; i++){');
				c('linkContent="";');
				#c('/*if a buildPager function is supplied,use it to get pager link value,else use index + 1*/');
				c('if(slider.settings.buildPager && $.isFunction(slider.settings.buildPager) || slider.settings.pagerCustom){');
					c('linkContent=slider.settings.buildPager(i);');
					c('slider.pagerEl.addClass("bx-custom-pager");');
				c('}else{');
					c('linkContent=i + 1;');
					c('slider.pagerEl.addClass("bx-default-pager");');
				c('}');
				#c('/*var linkContent=slider.settings.buildPager && $.isFunction(slider.settings.buildPager)?slider.settings.buildPager(i):i + 1;*/');
				#c('/*add the markup to the string*/');
				c('pagerHtml += "<div class=\"bx-pager-item\"><a href=\"\" data-slide-index=\"" + i + "\" class=\"bx-pager-link\">" + linkContent + "</a></div>";');
			c('}');
			#c('/*populate the pager element with pager links*/');
			c('slider.pagerEl.html(pagerHtml);');
		c('};');

		/**
		* Appends the pager to the controls element
		*/
		c('var appendPager=function(){');
			c('if(!slider.settings.pagerCustom){');
				#c('/*create the pager DOM element*/');
				c('slider.pagerEl=$("<div class=\"bx-pager\" />");');
				#c('/*if a pager selector was supplied,populate it with the pager*/');
				c('if(slider.settings.pagerSelector){');
					c('$(slider.settings.pagerSelector).html(slider.pagerEl);');
					#c('/*if no pager selector was supplied,add it after the wrapper*/');
				c('}else{');
					c('slider.controls.el.addClass("bx-has-pager").append(slider.pagerEl);');
				c('}');
				#c('/*populate the pager*/');
				c('populatePager();');
			c('}else{');
				c('slider.pagerEl=$(slider.settings.pagerCustom);');
			c('}');
			#c('/*assign the pager click binding*/');
			c('slider.pagerEl.on("click touchend","a",clickPagerBind);');
		c('};');

		/**
		* Appends prev / next controls to the controls element
		*/
		c('var appendControls=function(){');
			c('slider.controls.next=$("<a class=\"bx-next\" href=\"\">" + slider.settings.nextText + "</a>");');
			c('slider.controls.prev=$("<a class=\"bx-prev\" href=\"\">" + slider.settings.prevText + "</a>");');
			#c('/*bind click actions to the controls*/');
			c('slider.controls.next.bind("click touchend",clickNextBind);');
			c('slider.controls.prev.bind("click touchend",clickPrevBind);');
			#c('/*if nextSelector was supplied,populate it*/');
			c('if(slider.settings.nextSelector){');
				c('$(slider.settings.nextSelector).append(slider.controls.next);');
			c('}');
			#c('/*if prevSelector was supplied,populate it*/');
			c('if(slider.settings.prevSelector){');
				c('$(slider.settings.prevSelector).append(slider.controls.prev);');
			c('}');
			#c('/*if no custom selectors were supplied*/');
			c('if(!slider.settings.nextSelector && !slider.settings.prevSelector){');
				#c('/*add the controls to the DOM*/');
				c('slider.controls.directionEl=$("<div class=\"bx-controls-direction\" />");');
				#c('/*add the control elements to the directionEl*/');
				c('slider.controls.directionEl.append(slider.controls.prev).append(slider.controls.next);');
				#c('/*slider.viewport.append(slider.controls.directionEl);*/');
				c('slider.controls.el.addClass("bx-has-controls-direction").append(slider.controls.directionEl);');
			c('}');
		c('};');

		/**
		* Appends start / stop auto controls to the controls element
		*/
		c('var appendControlsAuto=function(){');
			c('slider.controls.start=$("<div class=\"bx-controls-auto-item\"><a class=\"bx-start\" href=\"\">" + slider.settings.startText + "</a></div>");');
			c('slider.controls.stop=$("<div class=\"bx-controls-auto-item\"><a class=\"bx-stop\" href=\"\">" + slider.settings.stopText + "</a></div>");');
			#c('/*add the controls to the DOM*/');
			c('slider.controls.autoEl=$("<div class=\"bx-controls-auto\" />");');
			#c('/*bind click actions to the controls*/');
			c('slider.controls.autoEl.on("click",".bx-start",clickStartBind);');
			c('slider.controls.autoEl.on("click",".bx-stop",clickStopBind);');
			#c('/*if autoControlsCombine,insert only the \"start\" control*/');
			c('if(slider.settings.autoControlsCombine){');
				c('slider.controls.autoEl.append(slider.controls.start);');
				#c('/*if autoControlsCombine is false,insert both controls*/');
			c('}else{');
				c('slider.controls.autoEl.append(slider.controls.start).append(slider.controls.stop);');
			c('}');
			#c('/*if auto controls selector was supplied,populate it with the controls*/');
			c('if(slider.settings.autoControlsSelector){');
				c('$(slider.settings.autoControlsSelector).html(slider.controls.autoEl);');
				#c('/*if auto controls selector was not supplied,add it after the wrapper*/');
			c('}else{');
				c('slider.controls.el.addClass("bx-has-controls-auto").append(slider.controls.autoEl);');
			c('}');
			#c('/*update the auto controls*/');
			c('updateAutoControls(slider.settings.autoStart?"stop":"start");');
		c('};');

		/**
		* Appends image captions to the DOM
		*/
		c('var appendCaptions=function(){');
			#c('/*cycle through each child*/');
			c('slider.children.each(function(index){');
				#c('/*get the image title attribute*/');
				c('var title=$(this).find("img:first").attr("title");');
				#c('/*append the caption*/');
				c('if(title!==undefined && ("" + title).length){');
					c('$(this).append("<div class=\"bx-caption\"><span>" + title + "</span></div>");');
				c('}');
			c('});');
		c('};');

		/**
		* Click next binding
		*
		* @param e (event)
		*	- DOM event object
		*/
		c('var clickNextBind=function(e){');
			c('e.preventDefault();');
			c('if(slider.controls.el.hasClass("disabled")){return;}');
			#c('/*if auto show is running,stop it*/');
			c('if(slider.settings.auto && slider.settings.stopAutoOnClick){el.stopAuto();}');
			c('el.goToNextSlide();');
		c('};');

		/**
		* Click prev binding
		*
		* @param e (event)
		*	- DOM event object
		*/
		c('var clickPrevBind=function(e){');
			c('e.preventDefault();');
			c('if(slider.controls.el.hasClass("disabled")){return;}');
			#c('/*if auto show is running,stop it*/');
			c('if(slider.settings.auto && slider.settings.stopAutoOnClick){el.stopAuto();}');
			c('el.goToPrevSlide();');
		c('};');

		/**
		* Click start binding
		*
		* @param e (event)
		*	- DOM event object
		*/
		c('var clickStartBind=function(e){');
			c('el.startAuto();');
			c('e.preventDefault();');
		c('};');

		/**
		* Click stop binding
		*
		* @param e (event)
		*	- DOM event object
		*/
		c('var clickStopBind=function(e){');
			c('el.stopAuto();');
			c('e.preventDefault();');
		c('};');

		/**
		* Click pager binding
		*
		* @param e (event)
		*	- DOM event object
		*/
		c('var clickPagerBind=function(e){');
			c('var pagerLink,pagerIndex;');
			c('e.preventDefault();');
			c('if(slider.controls.el.hasClass("disabled")){');
				c('return;');
			c('}');
			#c('/*if auto show is running,stop it*/');
			c('if(slider.settings.auto && slider.settings.stopAutoOnClick){el.stopAuto();}');
			c('pagerLink=$(e.currentTarget);');
			c('if(pagerLink.attr("data-slide-index")!==undefined){');
				c('pagerIndex=parseInt(pagerLink.attr("data-slide-index"));');
				#c('/*if clicked pager link is not active,continue with the goToSlide call*/');
				c('if(pagerIndex!==slider.active.index){el.goToSlide(pagerIndex);}');
			c('}');
		c('};');

		/**
		* Updates the pager links with an active class
		*
		* @param slideIndex (int)
		*	- index of slide to make active
		*/
		c('var updatePagerActive=function(slideIndex){');
			#c('/*if "short" pager type*/');
			#c('/*nb of children*/');
			c('var len=slider.children.length;');
			c('if(slider.settings.pagerType==="short"){');
				c('if(slider.settings.maxSlides > 1){');
					c('len=Math.ceil(slider.children.length / slider.settings.maxSlides);');
				c('}');
				c('slider.pagerEl.html((slideIndex + 1) + slider.settings.pagerShortSeparator + len);');
				c('return;');
			c('}');
			#c('/*remove all pager active classes*/');
			c('slider.pagerEl.find("a").removeClass("active");');
			#c('/*apply the active class for all pagers*/');
			c('slider.pagerEl.each(function(i,el){$(el).find("a").eq(slideIndex).addClass("active");});');
		c('};');

		/**
		* Performs needed actions after a slide transition
		*/
		c('var updateAfterSlideTransition=function(){');
			#c('/*if infinite loop is true*/');
			c('if(slider.settings.infiniteLoop){');
				c('var position="";');
				#c('/*first slide*/');
				c('if(slider.active.index===0){');
					#c('/*set the new position*/');
					c('position=slider.children.eq(0).position();');
					#c('/*carousel,last slide*/');
				c('}else if(slider.active.index===getPagerQty() - 1 && slider.carousel){');
					c('position=slider.children.eq((getPagerQty() - 1) * getMoveBy()).position();');
					#c('/*last slide*/');
				c('}else if(slider.active.index===slider.children.length - 1){');
					c('position=slider.children.eq(slider.children.length - 1).position();');
				c('}');
				c('if(position){');
					c('if(slider.settings.mode==="horizontal"){setPositionProperty(-position.left,"reset",0);}');
					c('else if(slider.settings.mode==="vertical"){setPositionProperty(-position.top,"reset",0);}');
				c('}');
			c('}');
			#c('/*declare that the transition is complete*/');
			c('slider.working=false;');
			#c('/*onSlideAfter callback*/');
			c('slider.settings.onSlideAfter.call(el,slider.children.eq(slider.active.index),slider.oldIndex,slider.active.index);');
		c('};');

		/**
		* Updates the auto controls state (either active,or combined switch)
		*
		* @param state (string) "start","stop"
		*	- the new state of the auto show
		*/
		c('var updateAutoControls=function(state){');
			#c('/*if autoControlsCombine is true,replace the current control with the new state*/');
			c('if(slider.settings.autoControlsCombine){');
				c('slider.controls.autoEl.html(slider.controls[state]);');
				#c('/*if autoControlsCombine is false,apply the "active" class to the appropriate control*/');
			c('}else{');
				c('slider.controls.autoEl.find("a").removeClass("active");');
				c('slider.controls.autoEl.find("a:not(.bx-" + state + ")").addClass("active");');
			c('}');
		c('};');

		/**
		* Updates the direction controls (checks if either should be hidden)
		*/
		c('var updateDirectionControls=function(){');
			c('if(getPagerQty()===1){');
				c('slider.controls.prev.addClass("disabled");');
				c('slider.controls.next.addClass("disabled");');
			c('}else if(!slider.settings.infiniteLoop && slider.settings.hideControlOnEnd){');
				#c('/*if first slide*/');
				c('if(slider.active.index===0){');
					c('slider.controls.prev.addClass("disabled");');
					c('slider.controls.next.removeClass("disabled");');
					#c('/*if last slide*/');
				c('}else if(slider.active.index===getPagerQty() - 1){');
					c('slider.controls.next.addClass("disabled");');
					c('slider.controls.prev.removeClass("disabled");');
					#c('/*if any slide in the middle*/');
				c('}else{');
					c('slider.controls.prev.removeClass("disabled");');
					c('slider.controls.next.removeClass("disabled");');
				c('}');
			c('}');
		c('};');
		
		/**
		* Initializes the auto process
		*/
		c('var initAuto=function(){');
			#c('/*if autoDelay was supplied,launch the auto show using a setTimeout() call*/');
			c('if(slider.settings.autoDelay > 0){');
				c('var timeout=setTimeout(el.startAuto,slider.settings.autoDelay);');
				#c('/*if autoDelay was not supplied,start the auto show normally*/');
			c('}else{');
				c('el.startAuto();');
				#c('/*add focus and blur events to ensure its running if timeout gets paused*/');
				c('$(window).focus(function(){');
					c('el.startAuto();');
				c('}).blur(function(){');
					c('el.stopAuto();');
				c('});');
			c('}');
			#c('/*if autoHover is requested*/');
			c('if(slider.settings.autoHover){');
				#c('/*on el hover*/');
				c('el.hover(function(){');
					#c('/*if the auto show is currently playing (has an active interval)*/');
					c('if(slider.interval){');
						#c('/*stop the auto show and pass true argument which will prevent control update*/');
						c('el.stopAuto(true);');
						#c('/*create a new autoPaused value which will be used by the relative "mouseout" event*/');
						c('slider.autoPaused=true;');
					c('}');
				c('},function(){');
					#c('/*if the autoPaused value was created be the prior "mouseover" event*/');
					c('if(slider.autoPaused){');
						#c('/*start the auto show and pass true argument which will prevent control update*/');
						c('el.startAuto(true);');
						#c('/*reset the autoPaused value*/');
						c('slider.autoPaused=null;');
					c('}');
				c('});');
			c('}');
		c('};');
		/**
		* Initializes the ticker process
		*/
		c('var initTicker=function(){');
			c('var startPosition=0,');
			c('position,transform,value,idx,ratio,property,newSpeed,totalDimens;');
			#c('/*if autoDirection is "next",append a clone of the entire slider*/');
			c('if(slider.settings.autoDirection==="next"){');
				c('el.append(slider.children.clone().addClass("bx-clone"));');
				#c('/*if autoDirection is "prev",prepend a clone of the entire slider,and set the left position*/');
			c('}else{');
				c('el.prepend(slider.children.clone().addClass("bx-clone"));');
				c('position=slider.children.first().position();');
				c('startPosition=slider.settings.mode==="horizontal"?-position.left:-position.top;');
			c('}');
			c('setPositionProperty(startPosition,"reset",0);');
			#c('/*do not allow controls in ticker mode*/');
			c('slider.settings.pager=false;');
			c('slider.settings.controls=false;');
			c('slider.settings.autoControls=false;');
			#c('/*if autoHover is requested*/');
			c('if(slider.settings.tickerHover){');
				c('if(slider.usingCSS){');
					c('idx=slider.settings.mode==="horizontal"?4:5;');
					c('slider.viewport.hover(function(){');
						c('transform=el.css("-" + slider.cssPrefix + "-transform");');
						c('value=parseFloat(transform.split(",")[idx]);');
						c('setPositionProperty(value,"reset",0);');
					c('},function(){');
						c('totalDimens=0;');
						c('slider.children.each(function(index){');
							c('totalDimens += slider.settings.mode==="horizontal"?$(this).outerWidth(true):$(this).outerHeight(true);');
						c('});');
						#c('/*calculate the speed ratio (used to determine the new speed to finish the paused animation)*/');
						c('ratio=slider.settings.speed / totalDimens;');
						#c('/*determine which property to use*/');
						c('property=slider.settings.mode==="horizontal"?"left":"top";');
						#c('/*calculate the new speed*/');
						c('newSpeed=ratio * (totalDimens - (Math.abs(parseInt(value))));');
						c('tickerLoop(newSpeed);');
					c('});');
				c('}else{');
					#c('/*on el hover*/');
					c('slider.viewport.hover(function(){');
						c('el.stop();');
					c('},function(){');
						#c('/*calculate the total width of children (used to calculate the speed ratio)*/');
						c('totalDimens=0;');
						c('slider.children.each(function(index){');
							c('totalDimens += slider.settings.mode==="horizontal"?$(this).outerWidth(true):$(this).outerHeight(true);');
						c('});');
						#c('/*calculate the speed ratio (used to determine the new speed to finish the paused animation)*/');
						c('ratio=slider.settings.speed / totalDimens;');
						#c('/*determine which property to use*/');
						c('property=slider.settings.mode==="horizontal"?"left":"top";');
						#c('/*calculate the new speed*/');
						c('newSpeed=ratio * (totalDimens - (Math.abs(parseInt(el.css(property)))));');
						c('tickerLoop(newSpeed);');
					c('});');
				c('}');
			c('}');
			#c('/*start the ticker loop*/');
			c('tickerLoop();');
		c('};');

		/**
		* Runs a continuous loop,news ticker-style
		*/
		c('var tickerLoop=function(resumeSpeed){');
			c('var speed=resumeSpeed?resumeSpeed:slider.settings.speed,');
			c('position={left:0,top:0},');
			c('reset={left:0,top:0},');
			c('animateProperty,resetValue,params;');
			#c('/*if "next" animate left position to last child,then reset left to 0*/');
			c('if(slider.settings.autoDirection==="next"){');
				c('position=el.find(".bx-clone").first().position();');
				#c('/*if "prev" animate left position to 0,then reset left to first non-clone child*/');
			c('}else{');
				c('reset=slider.children.first().position();');
			c('}');
			c('animateProperty=slider.settings.mode==="horizontal"?-position.left:-position.top;');
			c('resetValue=slider.settings.mode==="horizontal"?-reset.left:-reset.top;');
			c('params={resetValue:resetValue};');
			c('setPositionProperty(animateProperty,"ticker",speed,params);');
		c('};');

		/**
		* Check if el is on screen
		*/
		c('var isOnScreen=function(el){');
			c('var win=$(window),');
			c('viewport={');
				c('top:win.scrollTop(),');
				c('left:win.scrollLeft()');
			c('},');
			c('bounds=el.offset();');
			c('viewport.right=viewport.left + win.width();');
			c('viewport.bottom=viewport.top + win.height();');
			c('bounds.right=bounds.left + el.outerWidth();');
			c('bounds.bottom=bounds.top + el.outerHeight();');
			c('return (!(viewport.right < bounds.left || viewport.left > bounds.right || viewport.bottom < bounds.top || viewport.top > bounds.bottom));');
		c('};');

		/**
		* Initializes keyboard events
		*/
		c('var keyPress=function(e){');
			c('var activeElementTag=document.activeElement.tagName.toLowerCase(),');
			c('tagFilters="input|textarea",');
			c('p=new RegExp(activeElementTag,["i"]),');
			c('result=p.exec(tagFilters);');
			c('if(result == null && isOnScreen(el)){');
				c('if(e.keyCode===39){');
					c('clickNextBind(e);');
					c('return false;');
				c('}else if(e.keyCode===37){');
					c('clickPrevBind(e);');
					c('return false;');
				c('}');
			c('}');
		c('};');
		
		/**
		* Initializes touch events
		*/
		c('var initTouch=function(){');
			#c('/*initialize object to contain all touch values*/');
			c('slider.touch={');
				c('start:{x:0,y:0},');
				c('end:{x:0,y:0}');
			c('};');
			c('slider.viewport.bind("touchstart MSPointerDown pointerdown",onTouchStart);');
			#c('/*for browsers that have implemented pointer events and fire a click after*/');
			#c('/*every pointerup regardless of whether pointerup is on same screen location as pointerdown or not*/');
			c('slider.viewport.on("click",".bxslider a",function(e){');
				c('if(slider.viewport.hasClass("click-disabled")){');
					c('e.preventDefault();');
					c('slider.viewport.removeClass("click-disabled");');
				c('}');
			c('});');
		c('};');

		/**
		* Event handler for "touchstart"
		*
		* @param e (event)
		*	- DOM event object
		*/
		c('var onTouchStart=function(e){');
			#c('/*disable slider controls while user is interacting with slides to avoid slider freeze that happens on touch devices when a slide swipe happens immediately after interacting with slider controls*/');
			c('slider.controls.el.addClass("disabled");');
			c('if(slider.working){');
				c('e.preventDefault();');
				c('slider.controls.el.removeClass("disabled");');
			c('}else{');
				#c('/*record the original position when touch starts*/');
				c('slider.touch.originalPos=el.position();');
				c('var orig=e.originalEvent,');
				c('touchPoints=(typeof orig.changedTouches!=="undefined")?orig.changedTouches:[orig];');
				#c('/*record the starting touch x,y coordinates*/');
				c('slider.touch.start.x=touchPoints[0].pageX;');
				c('slider.touch.start.y=touchPoints[0].pageY;');
				c('if(slider.viewport.get(0).setPointerCapture){');
					c('slider.pointerId=orig.pointerId;');
					c('slider.viewport.get(0).setPointerCapture(slider.pointerId);');
				c('}');
				#c('/*bind a "touchmove" event to the viewport*/');
				c('slider.viewport.bind("touchmove MSPointerMove pointermove",onTouchMove);');
				#c('/*bind a "touchend" event to the viewport*/');
				c('slider.viewport.bind("touchend MSPointerUp pointerup",onTouchEnd);');
				c('slider.viewport.bind("MSPointerCancel pointercancel",onPointerCancel);');
			c('}');
		c('};');

		/**
		* Cancel Pointer for Windows Phone
		*
		* @param e (event)
		*	- DOM event object
		*/
		c('var onPointerCancel=function(e){');
			#c('/* onPointerCancel handler is needed to deal with situations when a touchend doesn\'t fire after a touchstart (this happens on windows phones only) */');
			c('setPositionProperty(slider.touch.originalPos.left,"reset",0);');
			#c('/*remove handlers*/');
			c('slider.controls.el.removeClass("disabled");');
			c('slider.viewport.unbind("MSPointerCancel pointercancel",onPointerCancel);');
			c('slider.viewport.unbind("touchmove MSPointerMove pointermove",onTouchMove);');
			c('slider.viewport.unbind("touchend MSPointerUp pointerup",onTouchEnd);');
			c('if(slider.viewport.get(0).releasePointerCapture){');
				c('slider.viewport.get(0).releasePointerCapture(slider.pointerId);');
			c('}');
		c('};');

		/**
		* Event handler for "touchmove"
		*
		* @param e (event)
		*	- DOM event object
		*/
		c('var onTouchMove=function(e){');
			c('var orig=e.originalEvent,');
			c('touchPoints=(typeof orig.changedTouches!=="undefined")?orig.changedTouches:[orig],');
			#c('/*if scrolling on y axis,do not prevent default*/');
			c('xMovement=Math.abs(touchPoints[0].pageX - slider.touch.start.x),');
			c('yMovement=Math.abs(touchPoints[0].pageY - slider.touch.start.y),');
			c('value=0,');
			c('change=0;');
			#c('/*x axis swipe*/');
			c('if((xMovement * 3) > yMovement && slider.settings.preventDefaultSwipeX){');
				c('e.preventDefault();');
			c('}else if((yMovement * 3) > xMovement && slider.settings.preventDefaultSwipeY){');
				#c('/*y axis swipe*/');
				c('e.preventDefault();');
			c('}');
			c('if(slider.settings.mode!=="fade" && slider.settings.oneToOneTouch){');
				#c('/*if horizontal,drag along x axis*/');
				c('if(slider.settings.mode==="horizontal"){');
					c('change=touchPoints[0].pageX - slider.touch.start.x;');
					c('value=slider.touch.originalPos.left + change;');
				#c('/*if vertical,drag along y axis*/');
				c('}else{');
					c('change=touchPoints[0].pageY - slider.touch.start.y;');
					c('value=slider.touch.originalPos.top + change;');
				c('}');
				c('setPositionProperty(value,"reset",0);');
			c('}');
		c('};');
		/**
		* Event handler for "touchend"
		*
		* @param e (event)
		*	- DOM event object
		*/
		c('var onTouchEnd=function(e){');
			c('slider.viewport.unbind("touchmove MSPointerMove pointermove",onTouchMove);');
			#c('/*enable slider controls as soon as user stops interacing with slides*/');
			c('slider.controls.el.removeClass("disabled");');
			c('var orig=e.originalEvent,');
			c('touchPoints=(typeof orig.changedTouches!=="undefined")?orig.changedTouches:[orig],');
			c('value=0,');
			c('distance=0;');
			#c('/*record end x,y positions*/');
			c('slider.touch.end.x=touchPoints[0].pageX;');
			c('slider.touch.end.y=touchPoints[0].pageY;');
			#c('/*if fade mode,check if absolute x distance clears the threshold*/');
			c('if(slider.settings.mode==="fade"){');
				c('distance=Math.abs(slider.touch.start.x - slider.touch.end.x);');
				c('if(distance >= slider.settings.swipeThreshold){');
					c('if(slider.touch.start.x > slider.touch.end.x){');
						c('el.goToNextSlide();');
					c('}else{');
						c('el.goToPrevSlide();');
					c('}');
					c('el.stopAuto();');
				c('}');
				#c('/*not fade mode*/');
			c('}else{');
				#c('/*calculate distance and el"s animate property*/');
				c('if(slider.settings.mode==="horizontal"){');
					c('distance=slider.touch.end.x - slider.touch.start.x;');
					c('value=slider.touch.originalPos.left;');
				c('}else{');
					c('distance=slider.touch.end.y - slider.touch.start.y;');
					c('value=slider.touch.originalPos.top;');
				c('}');
				#c('/*if not infinite loop and first / last slide,do not attempt a slide transition*/');
				c('if(!slider.settings.infiniteLoop && ((slider.active.index===0 && distance > 0) || (slider.active.last && distance < 0))){');
					c('setPositionProperty(value,"reset",200);');
				c('}else{');
					#c('/*check if distance clears threshold*/');
					c('if(Math.abs(distance) >= slider.settings.swipeThreshold){');
						c('if(distance < 0){');
							c('el.goToNextSlide();');
						c('}else{');
							c('el.goToPrevSlide();');
						c('}');
						c('el.stopAuto();');
					c('}else{');
						#c('/*el.animate(property,200);*/');
						c('setPositionProperty(value,"reset",200);');
					c('}');
				c('}');
			c('}');
			c('slider.viewport.unbind("touchend MSPointerUp pointerup",onTouchEnd);');
			c('if(slider.viewport.get(0).releasePointerCapture){');
				c('slider.viewport.get(0).releasePointerCapture(slider.pointerId);');
			c('}');
		c('};');

		/**
		* Window resize event callback
		*/
		c('var resizeWindow=function(e){');
			#c('/*don't do anything if slider isn't initialized.*/');
			c('if(!slider.initialized){return;}');
			#c('/*Delay if slider working.*/');
			c('if(slider.working){');
				c('window.setTimeout(resizeWindow,10);');
			c('}else{');
				#c('/*get the new window dimens (again,thank you IE)*/');
				c('var windowWidthNew=$(window).width(),');
				c('windowHeightNew=$(window).height();');
				#c('/*make sure that it is a true window resize*/');
				#c('/**we must check this because our dinosaur friend IE fires a window resize event when certain DOM elements*/');
				#c('/*are resized. Can you just die already?**/');
				c('if(windowWidth!==windowWidthNew || windowHeight!==windowHeightNew){');
					#c('/*set the new window dimens*/');
					c('windowWidth=windowWidthNew;');
					c('windowHeight=windowHeightNew;');
					#c('/*update all dynamic elements*/');
					c('el.redrawSlider();');
					#c('/*Call user resize handler*/');
					c('slider.settings.onSliderResize.call(el,slider.active.index);');
				c('}');
			c('}');
		c('};');

		/**
		* Adds an aria-hidden=true attribute to each element
		*
		* @param startVisibleIndex (int)
		*	- the first visible element's index
		*/
		c('var applyAriaHiddenAttributes=function(startVisibleIndex){');
			c('var numberOfSlidesShowing=getNumberSlidesShowing();');
			#c('/*only apply attributes if the setting is enabled and not in ticker mode*/');
			c('if(slider.settings.ariaHidden && !slider.settings.ticker){');
				#c('/*add aria-hidden=true to all elements*/');
				c('slider.children.attr("aria-hidden","true");');
				#c('/*get the visible elements and change to aria-hidden=false*/');
				c('slider.children.slice(startVisibleIndex,startVisibleIndex + numberOfSlidesShowing).attr("aria-hidden","false");');
			c('}');
		c('};');

		/**
		* Returns index according to present page range
		*
		* @param slideOndex (int)
		*	- the desired slide index
		*/
		c('var setSlideIndex=function(slideIndex){');
			c('if(slideIndex < 0){');
				c('if(slider.settings.infiniteLoop){');
					c('return getPagerQty() - 1;');
				c('}else{');
					#c('/*we don\'t go to undefined slides*/');
					c('return slider.active.index;');
				c('}');
				#c('/*if slideIndex is greater than children length,set active index to 0 (this happens during infinite loop)*/');
			c('}else if(slideIndex >= getPagerQty()){');
				c('if(slider.settings.infiniteLoop){');
					c('return 0;');
				c('}else{');
					#c('/*we don\'t move to undefined pages*/');
					c('return slider.active.index;');
				c('}');
				#c('/*set active index to requested slide*/');
			c('}else{');
				c('return slideIndex;');
			c('}');
		c('};');

		/**
		* ===================================================================================
		*=PUBLIC FUNCTIONS
		* ===================================================================================
		*/
		
		/**
		* Performs slide transition to the specified slide
		*
		* @param slideIndex (int)
		*	- the destination slide\'s index (zero-based)
		*
		* @param direction (string)
		*	- INTERNAL USE ONLY - the direction of travel ("prev" / "next")
		*/
		c('el.goToSlide=function(slideIndex,direction){');
			#c('/*onSlideBefore,onSlideNext,onSlidePrev callbacks*/');
			#c('/*Allow transition canceling based on returned value*/');
			c('var performTransition=true,');
			c('moveBy=0,');
			c('position={left:0,top:0},');
			c('lastChild=null,');
			c('lastShowingIndex,eq,value,requestEl;');
			#c('/*store the old index*/');
			c('slider.oldIndex=slider.active.index;');
			#c('/*set new index*/');
			c('slider.active.index=setSlideIndex(slideIndex);');
			#c('/*if plugin is currently in motion,ignore request*/');
			c('if(slider.working || slider.active.index===slider.oldIndex){return;}');
			#c('/*declare that plugin is in motion*/');
			c('slider.working=true;');
			c('performTransition=slider.settings.onSlideBefore.call(el,slider.children.eq(slider.active.index),slider.oldIndex,slider.active.index);');
			#c('/*If transitions canceled,reset and return*/');
			c('if(typeof (performTransition)!=="undefined" && !performTransition){');
				c('slider.active.index=slider.oldIndex;');
				#c('/*restore old index*/');
				c('slider.working=false;');
				#c('/*is not in motion*/');
				c('return;');
			c('}');
			c('if(direction==="next"){');
				#c('/*Prevent canceling in future functions or lack there-of from negating previous commands to cancel*/');
				c('if(!slider.settings.onSlideNext.call(el,slider.children.eq(slider.active.index),slider.oldIndex,slider.active.index)){');
					c('performTransition=false;');
				c('}');
			c('}else if(direction==="prev"){');
				#c('/*Prevent canceling in future functions or lack there-of from negating previous commands to cancel*/');
				c('if(!slider.settings.onSlidePrev.call(el,slider.children.eq(slider.active.index),slider.oldIndex,slider.active.index)){');
					c('performTransition=false;');
				c('}');
			c('}');
			#c('/*check if last slide*/');
			c('slider.active.last=slider.active.index >= getPagerQty() - 1;');
			#c('/*update the pager with active class*/');
			c('if(slider.settings.pager || slider.settings.pagerCustom){updatePagerActive(slider.active.index);}');
			#c('/*check for direction control update*/');
			c('if(slider.settings.controls){updateDirectionControls();}');
			#c('/*if slider is set to mode:"fade"*/');
			c('if(slider.settings.mode==="fade"){');
				#c('/*if adaptiveHeight is true and next height is different from current height,animate to the new height*/');
				c('if(slider.settings.adaptiveHeight && slider.viewport.height()!==getViewportHeight()){');
					c('slider.viewport.animate({height:getViewportHeight()},slider.settings.adaptiveHeightSpeed);');
				c('}');
				#c('/*fade out the visible child and reset its z-index value*/');
				c('slider.children.filter(":visible").fadeOut(slider.settings.speed).css({zIndex:0});');
				#c('/*fade in the newly requested slide*/');
				c('slider.children.eq(slider.active.index).css("zIndex",slider.settings.slideZIndex + 1).fadeIn(slider.settings.speed,function(){');
					c('$(this).css("zIndex",slider.settings.slideZIndex);');
					c('updateAfterSlideTransition();');
				c('});');
			c('}else{');
				#c('/*slider mode is not "fade"*/');
				#c('/*if adaptiveHeight is true and next height is different from current height,animate to the new height*/');
				c('if(slider.settings.adaptiveHeight && slider.viewport.height()!==getViewportHeight()){');
					c('slider.viewport.animate({height:getViewportHeight()},slider.settings.adaptiveHeightSpeed);');
				c('}');
				#c('/*if carousel and not infinite loop*/');
				c('if(!slider.settings.infiniteLoop && slider.carousel && slider.active.last){');
					c('if(slider.settings.mode==="horizontal"){');
						#c('/*get the last child position*/');
						c('lastChild=slider.children.eq(slider.children.length - 1);');
						c('position=lastChild.position();');
						#c('/*calculate the position of the last slide*/');
						c('moveBy=slider.viewport.width() - lastChild.outerWidth();');
					c('}else{');
						#c('/*get last showing index position*/');
						c('lastShowingIndex=slider.children.length - slider.settings.minSlides;');
						c('position=slider.children.eq(lastShowingIndex).position();');
					c('}');
					#c('/*horizontal carousel,going previous while on first slide (infiniteLoop mode)*/');
				c('}else if(slider.carousel && slider.active.last && direction==="prev"){');
					#c('/*get the last child position*/');
					c('eq=slider.settings.moveSlides===1?slider.settings.maxSlides - getMoveBy():((getPagerQty() - 1) * getMoveBy()) - (slider.children.length - slider.settings.maxSlides);');
					c('lastChild=el.children(".bx-clone").eq(eq);');
					c('position=lastChild.position();');
				#c('/*if infinite loop and "Next" is clicked on the last slide*/');
				c('}else if(direction==="next" && slider.active.index===0){');
					#c('/*get the last clone position*/');
					c('position=el.find("> .bx-clone").eq(slider.settings.maxSlides).position();');
					c('slider.active.last=false;');
				#c('/*normal non-zero requests*/');
				c('}else if(slideIndex >= 0){');
					#c('/*parseInt is applied to allow floats for slides/page*/');
					c('requestEl=slideIndex * parseInt(getMoveBy());');
					c('position=slider.children.eq(requestEl).position();');
				c('}');
				/* If the position doesn\'t exist
				* (e.g. if you destroy the slider on a next click),
				* it doesn\'t throw an error.
				*/
				c('if(typeof (position)!=="undefined"){');
					c('value=slider.settings.mode==="horizontal"?-(position.left - moveBy):-position.top;');
					#c('/*plugin values to be animated*/');
					c('setPositionProperty(value,"slide",slider.settings.speed);');
				c('}else{');
					c('slider.working=false;');
				c('}');
			c('}');
			c('if(slider.settings.ariaHidden){applyAriaHiddenAttributes(slider.active.index * getMoveBy());}');
		c('};');

		/**
		* Transitions to the next slide in the show
		*/
		c('el.goToNextSlide=function(){');
			#c('/*if infiniteLoop is false and last page is showing,disregard call*/');
			c('if(!slider.settings.infiniteLoop && slider.active.last){return;}');
			c('var pagerIndex=parseInt(slider.active.index) + 1;');
			c('el.goToSlide(pagerIndex,"next");');
		c('};');

		/**
		* Transitions to the prev slide in the show
		*/
		c('el.goToPrevSlide=function(){');
			#c('/*if infiniteLoop is false and last page is showing,disregard call*/');
			c('if(!slider.settings.infiniteLoop && slider.active.index===0){return;}');
			c('var pagerIndex=parseInt(slider.active.index) - 1;');
			c('el.goToSlide(pagerIndex,"prev");');
		c('};');

		/**
		* Starts the auto show
		*
		* @param preventControlUpdate (boolean)
		*	- if true,auto controls state will not be updated
		*/
		c('el.startAuto=function(preventControlUpdate){');
			#c('/*if an interval already exists,disregard call*/');
			c('if(slider.interval){return;}');
			#c('/*create an interval*/');
			c('slider.interval=setInterval(function(){');
				c('if(slider.settings.autoDirection==="next"){');
					c('el.goToNextSlide();');
				c('}else{');
					c('el.goToPrevSlide();');
				c('}');
			c('},slider.settings.pause);');
			#c('/*if auto controls are displayed and preventControlUpdate is not true*/');
			c('if(slider.settings.autoControls && preventControlUpdate!==true){updateAutoControls("stop");}');
		c('};');

		/**
		* Stops the auto show
		*
		* @param preventControlUpdate (boolean)
		*	- if true,auto controls state will not be updated
		*/
		c('el.stopAuto=function(preventControlUpdate){');
			#c('/*if no interval exists,disregard call*/');
			c('if(!slider.interval){return;}');
			#c('/*clear the interval*/');
			c('clearInterval(slider.interval);');
			c('slider.interval=null;');
			#c('/*if auto controls are displayed and preventControlUpdate is not true*/');
			c('if(slider.settings.autoControls && preventControlUpdate!==true){updateAutoControls("start");}');
		c('};');

		/**
		* Returns current slide index (zero-based)
		*/
		c('el.getCurrentSlide=function(){');
			c('return slider.active.index;');
		c('};');

		/**
		* Returns current slide element
		*/
		c('el.getCurrentSlideElement=function(){');
			c('return slider.children.eq(slider.active.index);');
		c('};');
		/**
		* Returns a slide element
		* @param index (int)
		*	- The index (zero-based) of the element you want returned.
		*/
		c('el.getSlideElement=function(index){');
			c('return slider.children.eq(index);');
		c('};');
		/**
		* Returns number of slides in show
		*/
		c('el.getSlideCount=function(){');
			c('return slider.children.length;');
		c('};');
		/**
		* Return slider.working variable
		*/
		c('el.isWorking=function(){');
			c('return slider.working;');
		c('};');
		/**
		* Update all dynamic slider elements
		*/
		c('el.redrawSlider=function(){');
			#c('/*resize all children in ratio to new screen size*/');
			c('slider.children.add(el.find(".bx-clone")).outerWidth(getSlideWidth());');
			#c('/*adjust the height*/');
			c('slider.viewport.css("height",getViewportHeight());');
			#c('/*update the slide position*/');
			c('if(!slider.settings.ticker){setSlidePosition();}');
			#c('/*if active.last was true before the screen resize,we want*/');
			#c('/*to keep it last no matter what screen size we end on*/');
			c('if(slider.active.last){slider.active.index=getPagerQty() - 1;}');
			#c('/*if the active index (page) no longer exists due to the resize,simply set the index as last*/');
			c('if(slider.active.index >= getPagerQty()){slider.active.last=true;}');
			#c('/*if a pager is being displayed and a custom pager is not being used,update it*/');
			c('if(slider.settings.pager && !slider.settings.pagerCustom){');
				c('populatePager();');
				c('updatePagerActive(slider.active.index);');
			c('}');
			c('if(slider.settings.ariaHidden){applyAriaHiddenAttributes(slider.active.index * getMoveBy());}');
		c('};');

		/**
		* Destroy the current instance of the slider (revert everything back to original state)
		*/
		c('el.destroySlider=function(){');
			#c('/*don\'t do anything if slider has already been destroyed*/');
			c('if(!slider.initialized){return;}');
			c('slider.initialized=false;');
			c('$(".bx-clone",this).remove();');
			c('slider.children.each(function(){');
				c('if($(this).data("origStyle")!==undefined){');
					c('$(this).attr("style",$(this).data("origStyle"));');
				c('}else{');
					c('$(this).removeAttr("style");');
				c('}');
			c('});');
			c('if($(this).data("origStyle")!==undefined){');
				c('this.attr("style",$(this).data("origStyle"));');
			c('}else{');
				c('$(this).removeAttr("style");');
			c('}');
			c('$(this).unwrap().unwrap();');
			c('if(slider.controls.el){slider.controls.el.remove();}');
			c('if(slider.controls.next){slider.controls.next.remove();}');
			c('if(slider.controls.prev){slider.controls.prev.remove();}');
			c('if(slider.pagerEl && slider.settings.controls && !slider.settings.pagerCustom){slider.pagerEl.remove();}');
			c('$(".bx-caption",this).remove();');
			c('if(slider.controls.autoEl){slider.controls.autoEl.remove();}');
			c('clearInterval(slider.interval);');
			c('if(slider.settings.responsive){$(window).unbind("resize",resizeWindow);}');
			c('if(slider.settings.keyboardEnabled){$(document).unbind("keydown",keyPress);}');
			#c('/*remove self reference in data*/');
			c('$(this).removeData("bxSlider");');
		c('};');

		/**
		* Reload the slider (revert all DOM changes,and re-initialize)
		*/
		c('el.reloadSlider=function(settings){');
			c('if(settings!==undefined){options=settings;}');
			c('el.destroySlider();');
			c('init();');
			#c('/*store reference to self in order to access public functions later*/');
			c('$(el).data("bxSlider",this);');
		c('};');
		c('init();');
		c('$(el).data("bxSlider",this);');
		#c('/*returns the current jQuery object*/');
		c('return this;');
	c('};');
c('})(jQuery);');
?>