//////////////////////////////////////////////////////////////////////////
//                                                                      //
// This is a generated file. You can view the original                  //
// source in your browser if your browser supports source maps.         //
// Source maps are supported by all recent versions of Chrome, Safari,  //
// and Firefox, and by Internet Explorer 11.                            //
//                                                                      //
//////////////////////////////////////////////////////////////////////////


(function () {

/* Imports */
var Meteor = Package.meteor.Meteor;
var global = Package.meteor.global;
var meteorEnv = Package.meteor.meteorEnv;
var CryptoJS = Package['jparker:crypto-core'].CryptoJS;

(function(){

////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                    //
// packages/jparker_crypto-padding/packages/jparker_crypto-padding.js                                 //
//                                                                                                    //
////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                      //
(function () {                                                                                        // 1
                                                                                                      // 2
//////////////////////////////////////////////////////////////////////////////////////////////////    // 3
//                                                                                              //    // 4
// packages/jparker:crypto-padding/lib/pad-ansix923.js                                          //    // 5
//                                                                                              //    // 6
//////////////////////////////////////////////////////////////////////////////////////////////////    // 7
                                                                                                //    // 8
/**                                                                                             // 1  // 9
 * ANSI X.923 padding strategy.                                                                 // 2  // 10
 */                                                                                             // 3  // 11
CryptoJS.pad.AnsiX923 = {                                                                       // 4  // 12
    pad: function (data, blockSize) {                                                           // 5  // 13
        // Shortcuts                                                                            // 6  // 14
        var dataSigBytes = data.sigBytes;                                                       // 7  // 15
        var blockSizeBytes = blockSize * 4;                                                     // 8  // 16
                                                                                                // 9  // 17
        // Count padding bytes                                                                  // 10
        var nPaddingBytes = blockSizeBytes - dataSigBytes % blockSizeBytes;                     // 11
                                                                                                // 12
        // Compute last byte position                                                           // 13
        var lastBytePos = dataSigBytes + nPaddingBytes - 1;                                     // 14
                                                                                                // 15
        // Pad                                                                                  // 16
        data.clamp();                                                                           // 17
        data.words[lastBytePos >>> 2] |= nPaddingBytes << (24 - (lastBytePos % 4) * 8);         // 18
        data.sigBytes += nPaddingBytes;                                                         // 19
    },                                                                                          // 20
                                                                                                // 21
    unpad: function (data) {                                                                    // 22
        // Get number of padding bytes from last byte                                           // 23
        var nPaddingBytes = data.words[(data.sigBytes - 1) >>> 2] & 0xff;                       // 24
                                                                                                // 25
        // Remove padding                                                                       // 26
        data.sigBytes -= nPaddingBytes;                                                         // 27
    }                                                                                           // 28
};                                                                                              // 29
//////////////////////////////////////////////////////////////////////////////////////////////////    // 38
                                                                                                      // 39
}).call(this);                                                                                        // 40
                                                                                                      // 41
                                                                                                      // 42
                                                                                                      // 43
                                                                                                      // 44
                                                                                                      // 45
                                                                                                      // 46
(function () {                                                                                        // 47
                                                                                                      // 48
//////////////////////////////////////////////////////////////////////////////////////////////////    // 49
//                                                                                              //    // 50
// packages/jparker:crypto-padding/lib/pad-iso10126.js                                          //    // 51
//                                                                                              //    // 52
//////////////////////////////////////////////////////////////////////////////////////////////////    // 53
                                                                                                //    // 54
/**                                                                                             // 1  // 55
 * ISO 10126 padding strategy.                                                                  // 2  // 56
 */                                                                                             // 3  // 57
CryptoJS.pad.Iso10126 = {                                                                       // 4  // 58
    pad: function (data, blockSize) {                                                           // 5  // 59
        // Shortcut                                                                             // 6  // 60
        var blockSizeBytes = blockSize * 4;                                                     // 7  // 61
                                                                                                // 8  // 62
        // Count padding bytes                                                                  // 9  // 63
        var nPaddingBytes = blockSizeBytes - data.sigBytes % blockSizeBytes;                    // 10
                                                                                                // 11
        // Pad                                                                                  // 12
        data.concat(CryptoJS.lib.WordArray.random(nPaddingBytes - 1)).                          // 13
             concat(CryptoJS.lib.WordArray.create([nPaddingBytes << 24], 1));                   // 14
    },                                                                                          // 15
                                                                                                // 16
    unpad: function (data) {                                                                    // 17
        // Get number of padding bytes from last byte                                           // 18
        var nPaddingBytes = data.words[(data.sigBytes - 1) >>> 2] & 0xff;                       // 19
                                                                                                // 20
        // Remove padding                                                                       // 21
        data.sigBytes -= nPaddingBytes;                                                         // 22
    }                                                                                           // 23
};                                                                                              // 24
//////////////////////////////////////////////////////////////////////////////////////////////////    // 79
                                                                                                      // 80
}).call(this);                                                                                        // 81
                                                                                                      // 82
                                                                                                      // 83
                                                                                                      // 84
                                                                                                      // 85
                                                                                                      // 86
                                                                                                      // 87
(function () {                                                                                        // 88
                                                                                                      // 89
//////////////////////////////////////////////////////////////////////////////////////////////////    // 90
//                                                                                              //    // 91
// packages/jparker:crypto-padding/lib/pad-iso97971.js                                          //    // 92
//                                                                                              //    // 93
//////////////////////////////////////////////////////////////////////////////////////////////////    // 94
                                                                                                //    // 95
/**                                                                                             // 1  // 96
 * ISO/IEC 9797-1 Padding Method 2.                                                             // 2  // 97
 */                                                                                             // 3  // 98
CryptoJS.pad.Iso97971 = {                                                                       // 4  // 99
    pad: function (data, blockSize) {                                                           // 5  // 100
        // Add 0x80 byte                                                                        // 6  // 101
        data.concat(CryptoJS.lib.WordArray.create([0x80000000], 1));                            // 7  // 102
                                                                                                // 8  // 103
        // Zero pad the rest                                                                    // 9  // 104
        CryptoJS.pad.ZeroPadding.pad(data, blockSize);                                          // 10
    },                                                                                          // 11
                                                                                                // 12
    unpad: function (data) {                                                                    // 13
        // Remove zero padding                                                                  // 14
        CryptoJS.pad.ZeroPadding.unpad(data);                                                   // 15
                                                                                                // 16
        // Remove one more byte -- the 0x80 byte                                                // 17
        data.sigBytes--;                                                                        // 18
    }                                                                                           // 19
};                                                                                              // 20
//////////////////////////////////////////////////////////////////////////////////////////////////    // 116
                                                                                                      // 117
}).call(this);                                                                                        // 118
                                                                                                      // 119
                                                                                                      // 120
                                                                                                      // 121
                                                                                                      // 122
                                                                                                      // 123
                                                                                                      // 124
(function () {                                                                                        // 125
                                                                                                      // 126
//////////////////////////////////////////////////////////////////////////////////////////////////    // 127
//                                                                                              //    // 128
// packages/jparker:crypto-padding/lib/pad-nopadding.js                                         //    // 129
//                                                                                              //    // 130
//////////////////////////////////////////////////////////////////////////////////////////////////    // 131
                                                                                                //    // 132
/**                                                                                             // 1  // 133
 * A noop padding strategy.                                                                     // 2  // 134
 */                                                                                             // 3  // 135
CryptoJS.pad.NoPadding = {                                                                      // 4  // 136
    pad: function () {                                                                          // 5  // 137
    },                                                                                          // 6  // 138
                                                                                                // 7  // 139
    unpad: function () {                                                                        // 8  // 140
    }                                                                                           // 9  // 141
};                                                                                              // 10
//////////////////////////////////////////////////////////////////////////////////////////////////    // 143
                                                                                                      // 144
}).call(this);                                                                                        // 145
                                                                                                      // 146
                                                                                                      // 147
                                                                                                      // 148
                                                                                                      // 149
                                                                                                      // 150
                                                                                                      // 151
(function () {                                                                                        // 152
                                                                                                      // 153
//////////////////////////////////////////////////////////////////////////////////////////////////    // 154
//                                                                                              //    // 155
// packages/jparker:crypto-padding/lib/pad-zeropadding.js                                       //    // 156
//                                                                                              //    // 157
//////////////////////////////////////////////////////////////////////////////////////////////////    // 158
                                                                                                //    // 159
/**                                                                                             // 1  // 160
 * Zero padding strategy.                                                                       // 2  // 161
 */                                                                                             // 3  // 162
CryptoJS.pad.ZeroPadding = {                                                                    // 4  // 163
    pad: function (data, blockSize) {                                                           // 5  // 164
        // Shortcut                                                                             // 6  // 165
        var blockSizeBytes = blockSize * 4;                                                     // 7  // 166
                                                                                                // 8  // 167
        // Pad                                                                                  // 9  // 168
        data.clamp();                                                                           // 10
        data.sigBytes += blockSizeBytes - ((data.sigBytes % blockSizeBytes) || blockSizeBytes); // 11
    },                                                                                          // 12
                                                                                                // 13
    unpad: function (data) {                                                                    // 14
        // Shortcut                                                                             // 15
        var dataWords = data.words;                                                             // 16
                                                                                                // 17
        // Unpad                                                                                // 18
        var i = data.sigBytes - 1;                                                              // 19
        while (!((dataWords[i >>> 2] >>> (24 - (i % 4) * 8)) & 0xff)) {                         // 20
            i--;                                                                                // 21
        }                                                                                       // 22
        data.sigBytes = i + 1;                                                                  // 23
    }                                                                                           // 24
};                                                                                              // 25
//////////////////////////////////////////////////////////////////////////////////////////////////    // 185
                                                                                                      // 186
}).call(this);                                                                                        // 187
                                                                                                      // 188
////////////////////////////////////////////////////////////////////////////////////////////////////////

}).call(this);


/* Exports */
if (typeof Package === 'undefined') Package = {};
Package['jparker:crypto-padding'] = {};

})();
