$(function() {		
			
	JQTWEET = {
		 
		// Set twitter hash/user, number of tweets & id/class to append tweets
		// You need to clear tweet-date.txt before toggle between hash and user
		// for multiple hashtags, you can separate the hashtag with OR, eg:
		// hash: '%23jquery OR %23css'			    
		search: '', //leave this blank if you want to show user's tweet
		user: 'infoAlphabet66', //username infoAlphabet66
		numTweets: 5, //number of tweets
		appendTo: '.curl-tweets',
		useGridalicious: true,
		template: '<div class="tweet {adds}">{IMG} {TEXT}<div class="time">{AGO}</div></div><div class="sep"></div>',
		// core function of jqtweet
		// https://dev.twitter.com/docs/using-search
		loadTweets: function() {
			var request;
			
			// different JSON request {hash|user}
			if (JQTWEET.search) {
			  request = {
				  q: JQTWEET.search,
				  count: JQTWEET.numTweets,
				  api: 'search_tweets'
			  }
			} else {
			  request = {
				  q: JQTWEET.user,
				  count: JQTWEET.numTweets,
				  api: 'statuses_userTimeline'
			  }
			}
			/*
			$.ajax({
				url: '/_ajax/grabtweets.php',
				type: 'POST',
				data: request,
				success: function(resp){
					alert(resp);
				}
			});
			*/
			$.ajax({
				url: '/_ajax/grabtweets.php',
				type: 'POST',
				dataType: 'json',
				data: request,
				success: function(data, textStatus, xhr) {
					//alert(data[0].user.screen_name);
					if (data.httpstatus == 200) {
						if (JQTWEET.search) data = data.statuses;
						var text, name, img, allStr;
						try {
							// append tweets into page
							for (var i = 0; i < JQTWEET.numTweets; i++) {
								img = '';
								url = 'http://twitter.com/' + data[i].user.screen_name + '/status/' + data[i].id_str;
								try {
									if (data[i].entities['media']) {
										img = '<a href="' + url + '" target="_blank"><img width="220" src="' + data[i].entities['media'][0].media_url + '" /></a>';
									}
								} catch (e) {
									//no media
								}
								//allStr = "text: ["+ JQTWEET.ify.clean(data[i].text) +"]\n screen_name: ["+ data[i].user.screen_name +"]\n img: ["+ img +"]\n time: ["+ JQTWEET.timeAgo(data[i].created_at) +"]\n url: ["+ url +"]";
								//alert(allStr);
								$(JQTWEET.appendTo).append(
									JQTWEET.template.replace('{TEXT}', JQTWEET.ify.clean(data[i].text) )
										.replace('{USER}', data[i].user.screen_name)
										.replace('{IMG}', img)
										.replace('{AGO}', JQTWEET.timeAgo(data[i].created_at) )
										.replace('{URL}', url )
										.replace(' {adds}', '')
									
								);
							}
							$(JQTWEET.appendTo).append(
								JQTWEET.template.replace('{TEXT}', '<a href="https://twitter.com/intent/tweet?screen_name=infoAlphabet66" class="tweet-box-button web-intent" data-related="infoAlphabet66">Tweet to @infoAlphabet66</a>')
									.replace('{IMG} ', '')
									.replace('<div class="time">{AGO}</div>', '')
									.replace('<div class="sep"></div>', '')
									.replace(' {adds}', ' tw-button')
							);
							
							!function(d,s,id){var js,fjs=d.getElementsByTagName(s)[0],p=/^http:/.test(d.location)?'http':'https';if(!d.getElementById(id)){js=d.createElement(s);js.id=id;js.src=p+'://platform.twitter.com/widgets.js';fjs.parentNode.insertBefore(js,fjs);}}(document, 'script', 'twitter-wjs');
							
							$(".tweet-loading").remove();
							$(".curl-tweets").mCustomScrollbar({
								advanced:{
									updateOnContentResize: true
								},
								autoHideScrollbar: true,
								mouseWheelPixels: 50,
								scrollButtons:{
									enable: false
								},
								theme: "light"
							});
							
							
							
						} catch (e) {
							//item is less than item count
						}
						if (JQTWEET.useGridalicious) {
							//run grid-a-licious
							$(JQTWEET.appendTo).gridalicious({
								gutter: 13,
								width: 200,
								animate: true
							});
						}
					} else {
						//alert('no data returned');
						$(".curl-tweets").html('<div style="text-align:center;background:#000;padding:15px;">No Data Returned</div>');
					}
				}
			});
		},
		/**
		  * relative time calculator FROM TWITTER
		  * @param {string} twitter date string returned from Twitter API
		  * @return {string} relative time like "2 minutes ago"
		  */
		timeAgo: function(dateString) {
			var rightNow = new Date();
			var then = new Date(dateString);
			/*
			if ($.browser.msie) {
				// IE can't parse these crazy Ruby dates
				then = Date.parse(dateString.replace(/( \+)/, ' UTC$1'));
			}
			*/
			var diff = rightNow - then;
			
			var second = 1000,
			minute = second * 60,
			hour = minute * 60,
			day = hour * 24,
			week = day * 7;
			if (isNaN(diff) || diff < 0) {
				return ""; // return blank string if unknown
			}
			if (diff < second * 2) {
				// within 2 seconds
				return "right now";
			}
			if (diff < minute) {
				return Math.floor(diff / second) + " seconds ago";
			}
			if (diff < minute * 2) {
				return "about 1 minute ago";
			}
			if (diff < hour) {
				return Math.floor(diff / minute) + " minutes ago";
			}
			if (diff < hour * 2) {
				return "about 1 hour ago";
			}
			if (diff < day) {
				return  Math.floor(diff / hour) + " hours ago";
			}
			if (diff > day && diff < day * 2) {
				return "yesterday";
			}
			if (diff < day * 365) {
				return Math.floor(diff / day) + " days ago";
			}
			else {
				return "over a year ago";
			}
		}, // timeAgo()
		/**
		  * The Twitalinkahashifyer!
		  * http://www.dustindiaz.com/basement/ify.html
		  * Eg:
		  * ify.clean('your tweet text');
		  */
		ify: {
			link: function(tweet) {
				return tweet.replace(/\b(((https*\:\/\/)|www\.)[^\"\']+?)(([!?,.\)]+)?(\s|$))/g, function(link, m1, m2, m3, m4) {
				    //				 /\b(((https*\:\/\/)|www\.)[^\"\']+?)(([!?,.\)]+)?(\s|$))/g
					var http = m2.match(/w/) ? 'http://' : '';
					return '<a class="twtr-hyperlink" target="_blank" href="' + http + m1 + '">' + ((m1.length > 25) ? m1.substr(0, 24) + '...' : m1) + '</a>' + m4;
				});
			},
			at: function(tweet) {
				return tweet.replace(/\B[@]([a-zA-Z0-9_]{1,20})/g, function(m, username) {
					//				 /\B[@]([a-zA-Z0-9_]{1,20})/g
					return '<a target="_blank" class="twtr-atreply" href="http://twitter.com/intent/user?screen_name=' + username + '">@' + username + '</a>';
				});
			},
			list: function(tweet) {
				return tweet.replace(/\B[@]([a-zA-Z0-9_]{1,20}\/\w+)/g, function(m, userlist) {
					//				 /\B[@]([a-zA-Z0-9_]{1,20}\/\w+)/g
					return '<a target="_blank" class="twtr-atreply" href="http://twitter.com/' + userlist + '">@' + userlist + '</a>';
				});
			},
			hash: function(tweet) {
				return tweet.replace(/(^|\s+)#(\w+)/gi, function(m, before, hash) {
					//				 /(^|\s+)#(\w+)/gi
					return before + '<a target="_blank" class="twtr-hashtag" href="http://twitter.com/search?q=%23' + hash + '">#' + hash + '</a>';
				});
			},
			clean: function(tweet) {
				//return (this.link(tweet) +" |\n\n "+ this.list(tweet) +" |\n\n "+ this.at(tweet) +" |\n\n "+ this.hash(tweet) +" |\n\n "+ this.hash(this.at(this.list(this.link(tweet)))));
				//return (this.hash(this.link(tweet)));
				return this.hash(this.at(this.list(this.link(tweet))));
			}
		} // ify
	};
});

// start jqtweet!
$(document).ready(function () {
	// start jqtweet!
	$(".curl-tweets").html('<div class="tweet-loading" style="text-align:center;padding:5px;"><img src="/admin/img/ajax-loader.gif" alt="Loading" /></div>');
	JQTWEET.loadTweets();
	
});
// JavaScript Document