//////////////////////////////////////////////////////////////////////////
//                                                                      //
// This is a generated file. You can view the original                  //
// source in your browser if your browser supports source maps.         //
// Source maps are supported by all recent versions of Chrome, Safari,  //
// and Firefox, and by Internet Explorer 11.                            //
//                                                                      //
//////////////////////////////////////////////////////////////////////////


(function () {

/* Imports */
var Meteor = Package.meteor.Meteor;
var global = Package.meteor.global;
var meteorEnv = Package.meteor.meteorEnv;
var CryptoJS = Package['jparker:crypto-core'].CryptoJS;

(function(){

/////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                             //
// packages/jparker_crypto-base64/packages/jparker_crypto-base64.js                            //
//                                                                                             //
/////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                               //
(function () {                                                                                 // 1
                                                                                               // 2
//////////////////////////////////////////////////////////////////////////////////////////     // 3
//                                                                                      //     // 4
// packages/jparker:crypto-base64/lib/enc-base64.js                                     //     // 5
//                                                                                      //     // 6
//////////////////////////////////////////////////////////////////////////////////////////     // 7
                                                                                        //     // 8
/*                                                                                      // 1   // 9
CryptoJS v3.1.2                                                                         // 2   // 10
code.google.com/p/crypto-js                                                             // 3   // 11
(c) 2009-2013 by Jeff Mott. All rights reserved.                                        // 4   // 12
code.google.com/p/crypto-js/wiki/License                                                // 5   // 13
*/                                                                                      // 6   // 14
(function () {                                                                          // 7   // 15
    // Shortcuts                                                                        // 8   // 16
    var C = CryptoJS;                                                                   // 9   // 17
    var C_lib = C.lib;                                                                  // 10  // 18
    var WordArray = C_lib.WordArray;                                                    // 11  // 19
    var C_enc = C.enc;                                                                  // 12  // 20
                                                                                        // 13  // 21
    /**                                                                                 // 14  // 22
     * Base64 encoding strategy.                                                        // 15  // 23
     */                                                                                 // 16  // 24
    var Base64 = C_enc.Base64 = {                                                       // 17  // 25
        /**                                                                             // 18  // 26
         * Converts a word array to a Base64 string.                                    // 19  // 27
         *                                                                              // 20  // 28
         * @param {WordArray} wordArray The word array.                                 // 21  // 29
         *                                                                              // 22  // 30
         * @return {string} The Base64 string.                                          // 23  // 31
         *                                                                              // 24  // 32
         * @static                                                                      // 25  // 33
         *                                                                              // 26  // 34
         * @example                                                                     // 27  // 35
         *                                                                              // 28  // 36
         *     var base64String = CryptoJS.enc.Base64.stringify(wordArray);             // 29  // 37
         */                                                                             // 30  // 38
        stringify: function (wordArray) {                                               // 31  // 39
            // Shortcuts                                                                // 32  // 40
            var words = wordArray.words;                                                // 33  // 41
            var sigBytes = wordArray.sigBytes;                                          // 34  // 42
            var map = this._map;                                                        // 35  // 43
                                                                                        // 36  // 44
            // Clamp excess bits                                                        // 37  // 45
            wordArray.clamp();                                                          // 38  // 46
                                                                                        // 39  // 47
            // Convert                                                                  // 40  // 48
            var base64Chars = [];                                                       // 41  // 49
            for (var i = 0; i < sigBytes; i += 3) {                                     // 42  // 50
                var byte1 = (words[i >>> 2]       >>> (24 - (i % 4) * 8))       & 0xff; // 43  // 51
                var byte2 = (words[(i + 1) >>> 2] >>> (24 - ((i + 1) % 4) * 8)) & 0xff; // 44  // 52
                var byte3 = (words[(i + 2) >>> 2] >>> (24 - ((i + 2) % 4) * 8)) & 0xff; // 45  // 53
                                                                                        // 46  // 54
                var triplet = (byte1 << 16) | (byte2 << 8) | byte3;                     // 47  // 55
                                                                                        // 48  // 56
                for (var j = 0; (j < 4) && (i + j * 0.75 < sigBytes); j++) {            // 49  // 57
                    base64Chars.push(map.charAt((triplet >>> (6 * (3 - j))) & 0x3f));   // 50  // 58
                }                                                                       // 51  // 59
            }                                                                           // 52  // 60
                                                                                        // 53  // 61
            // Add padding                                                              // 54  // 62
            var paddingChar = map.charAt(64);                                           // 55  // 63
            if (paddingChar) {                                                          // 56  // 64
                while (base64Chars.length % 4) {                                        // 57  // 65
                    base64Chars.push(paddingChar);                                      // 58  // 66
                }                                                                       // 59  // 67
            }                                                                           // 60  // 68
                                                                                        // 61  // 69
            return base64Chars.join('');                                                // 62  // 70
        },                                                                              // 63  // 71
                                                                                        // 64  // 72
        /**                                                                             // 65  // 73
         * Converts a Base64 string to a word array.                                    // 66  // 74
         *                                                                              // 67  // 75
         * @param {string} base64Str The Base64 string.                                 // 68  // 76
         *                                                                              // 69  // 77
         * @return {WordArray} The word array.                                          // 70  // 78
         *                                                                              // 71  // 79
         * @static                                                                      // 72  // 80
         *                                                                              // 73  // 81
         * @example                                                                     // 74  // 82
         *                                                                              // 75  // 83
         *     var wordArray = CryptoJS.enc.Base64.parse(base64String);                 // 76  // 84
         */                                                                             // 77  // 85
        parse: function (base64Str) {                                                   // 78  // 86
            // Shortcuts                                                                // 79  // 87
            var base64StrLength = base64Str.length;                                     // 80  // 88
            var map = this._map;                                                        // 81  // 89
                                                                                        // 82  // 90
            // Ignore padding                                                           // 83  // 91
            var paddingChar = map.charAt(64);                                           // 84  // 92
            if (paddingChar) {                                                          // 85  // 93
                var paddingIndex = base64Str.indexOf(paddingChar);                      // 86  // 94
                if (paddingIndex != -1) {                                               // 87  // 95
                    base64StrLength = paddingIndex;                                     // 88  // 96
                }                                                                       // 89  // 97
            }                                                                           // 90  // 98
                                                                                        // 91  // 99
            // Convert                                                                  // 92  // 100
            var words = [];                                                             // 93  // 101
            var nBytes = 0;                                                             // 94  // 102
            for (var i = 0; i < base64StrLength; i++) {                                 // 95  // 103
                if (i % 4) {                                                            // 96  // 104
                    var bits1 = map.indexOf(base64Str.charAt(i - 1)) << ((i % 4) * 2);  // 97  // 105
                    var bits2 = map.indexOf(base64Str.charAt(i)) >>> (6 - (i % 4) * 2); // 98  // 106
                    words[nBytes >>> 2] |= (bits1 | bits2) << (24 - (nBytes % 4) * 8);  // 99  // 107
                    nBytes++;                                                           // 100
                }                                                                       // 101
            }                                                                           // 102
                                                                                        // 103
            return WordArray.create(words, nBytes);                                     // 104
        },                                                                              // 105
                                                                                        // 106
        _map: 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/='       // 107
    };                                                                                  // 108
}());                                                                                   // 109
                                                                                        // 110
//////////////////////////////////////////////////////////////////////////////////////////     // 119
                                                                                               // 120
}).call(this);                                                                                 // 121
                                                                                               // 122
/////////////////////////////////////////////////////////////////////////////////////////////////

}).call(this);


/* Exports */
if (typeof Package === 'undefined') Package = {};
Package['jparker:crypto-base64'] = {};

})();
